import React, { Component } from 'react';
import HeadingContext from './appHeadingContext';

export default class TitleChain extends Component {
  componentDidMount() {
    this.chainPush(this.props.children);
  }

  componentWillReceiveProps(newProps) {
    if (this.props.children !== newProps.children) {
      this.chainPull(this.props.children);
      this.chainPush(newProps.children);
    }
  }

  componentWillUnmount() {
    this.chainPull(this.props.children);
  }

  chainPull = () => {};

  chainPush = () => {};

  render() {
    return (
      <HeadingContext.Consumer>
        {({ pull, push }) => {
          this.chainPush = push;
          this.chainPull = pull;
        }}
      </HeadingContext.Consumer>
    );
  }
}
