import React, { FC, Ref } from 'react';
import Button from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import { withOverlay } from 'hoc/withOverlay';
import { withZIndex } from '@yandex-lego/components/withZIndex';
import { compose, withProps } from 'recompose';
import { mergeAllRefs } from '@yandex-lego/components/lib/mergeRefs';
import configs from './Preview.config';
import { PreviewProps } from './Preview.types';
import css from './Preview.module.css';
import { withEventAnchor } from 'components/UXLogger/EventAnchor';

const closeIcon = (className: string) => <Icon className={className} glyph="type-close" />;

const Preview: FC<PreviewProps> = React.forwardRef(
  ({ onClose, eObject, innerRef }, ref?: Ref<HTMLDivElement>) => {
    if (!eObject) {
      return null;
    }

    const config = configs[eObject.type];

    const element = React.createElement(config.component, {
      ...config.props,
      [config.idKey]: eObject.id,
    });

    return (
      <div data-testid="preview-issue" className={css.Preview} ref={mergeAllRefs(innerRef, ref)}>
        <div className={css.Preview__toolbar}>
          <Button view="clear" size="s" onClick={onClose} icon={closeIcon} />
        </div>
        <div className={css.Preview__content}>{element}</div>
      </div>
    );
  },
);

export default compose(
  withProps(({ eObject }) => ({
    visible: Boolean(eObject),
  })),
  withZIndex,
  withEventAnchor,
  withOverlay,
)(Preview);
