import get from 'lodash/get';
import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import { EObject } from '../types';

const {
  reducer,
  actions: { setEObject },
} = createSlice({
  name: 'issuePreview',
  initialState: {
    eObject: null as EObject | null,
  },
  reducers: {
    setEObject: (state, action: PayloadAction<EObject | null>) => {
      // eslint-disable-next-line no-param-reassign
      state.eObject = action.payload;
    },
  },
});

const getEObject: (state: any) => null | EObject = state => get(state, 'issuePreview.eObject');

export { setEObject, getEObject };

export default reducer;
