import React, { FC, useCallback, useContext } from 'react';
import { CallToProps } from 'components/Contact/Phone';
import { ETypeString } from 'types/entities';
import Link from '@crm/components/dist/lego2/Link';
import { callService } from 'services/CallService';
import { IssueIdContext } from '../Issue/IssueIdContext';

export const CallToUseLogBroker: FC<CallToProps> = (props) => {
  const { phoneData, children } = props;
  const { id } = phoneData;

  const issueId = useContext(IssueIdContext);

  const handleClick = useCallback(() => {
    callService.call({
      kikId: id,
      source: {
        eid: issueId || id,
        etype: issueId ? ETypeString.Issue : ETypeString.AccountKik,
      },
    });
  }, [id, issueId]);

  return <Link onClick={handleClick}>{children}</Link>;
};
