import React from 'react';
import { modal } from 'modules/requestForm2';
import { ExpandWidget } from 'components/ExpandWidget';
import { observer } from 'mobx-react-lite';
import { ExpandWidgetNewIssueProps } from './ExpandWidgetNewIssue.types';

export const ExpandWidgetNewIssue: React.FC<ExpandWidgetNewIssueProps> = observer(
  ({ className }) => {
    if (!modal.isMinimized) {
      return null;
    }

    return (
      <ExpandWidget
        onClick={() => modal.maximize()}
        text={'Создать новый тикет'}
        tone="grey"
        className={className}
      />
    );
  },
);
