import { createContext, createRef, RefObject } from 'react';
import Bluebird from 'bluebird';
import { BackendFile } from 'lego/components/AttachFiles';

export interface FileInputApi {
  updateFiles: (fileIdsToLink: number[], fileIdsToRemove: number[]) => Bluebird<void>;
  getCurrentFiles: () => BackendFile[];
}

export const MailFileInputContext = createContext<RefObject<FileInputApi>>(createRef());
export const MessageFileInputContext = createContext<RefObject<FileInputApi>>(createRef());
