import React, { PureComponent, ReactNode } from 'react';
import cx from 'classnames';
import { CounterProps } from './Counter.types';
import css from './Counter.module.css';

class Counter extends PureComponent<CounterProps> {
  public render(): ReactNode {
    const { color, count, className: outerClassName } = this.props;
    const className = cx(css.counter, css[`counter_color_${color}`], outerClassName);

    return <span className={className}>{count}</span>;
  }
}

export default Counter;
