import React from 'react';
import cx from 'classnames';
import Toggle from '../Toggle';
import Counter from '../Counter';
import { InnerProps } from './Filter.types';
import css from './Filter.module.css';
import { withReduxState } from '../withReduxState';

const PADDING_PER_NESTING_LEVEL = 20;

const Filter: React.FC<InnerProps> = (props) => {
  const { filter, onToggle, nestingLevel, isOpen, active, vtreeStyle = {} } = props;
  if (!filter) {
    return null;
  }

  const { name, counter, color, disabled, isLeaf } = filter;
  const onFilterClick = disabled ? undefined : props.onFilterClick;

  const rootClassName = cx(css.b, {
    [css.b_active]: active,
    [css.b_disabled]: disabled,
  });

  const style: React.CSSProperties = {
    ...vtreeStyle,
    paddingLeft: `${PADDING_PER_NESTING_LEVEL * nestingLevel}px`,
  };

  return (
    <div className={rootClassName} style={style}>
      <div className={css.b__content} role="presentation" onClick={onFilterClick}>
        {!isLeaf && <Toggle className={css.b__toggle} isExpanded={isOpen} onClick={onToggle} />}
        <span className={css.b__text}>{name}</span>
        {counter != null && <Counter count={counter} color={color} className={css.b__counter} />}
      </div>
    </div>
  );
};

export default withReduxState(Filter);
