import { InjectedReduxContextProps } from 'modules/issues/redux';

export interface FilterObject {
  id: string;
  name: string;
  counter: string | number;
  color: string;
  isLeaf: boolean;
  disabled?: boolean;
  items?: unknown[];
}

export interface PropsAsVTreeComponent {
  filter: FilterObject;
  nestingLevel: number;
  isOpen: boolean;
  vtreeStyle?: React.CSSProperties;
}

export interface FilterOwnProps {
  disabled?: boolean;
}

export interface ConnectedStateProps {
  active: boolean;
}

export interface ConnectedDispatchProps {
  onFilterClick: () => void;
  onToggle: () => void;
}

export type InnerProps = PropsAsVTreeComponent &
  FilterOwnProps &
  ConnectedStateProps &
  InjectedReduxContextProps &
  ConnectedDispatchProps;

export type OuterProps = FilterOwnProps & PropsAsVTreeComponent;
