import React, { FC } from 'react';
import AutoSizer from 'react-virtualized-auto-sizer';
import { FixedSizeTree as Tree } from 'react-vtree';
import memoize from 'memoize-one';
import { createTreeWalker } from '../utils/treeWalker';
import Filter from '../Filter';
import { FilterTreeProps, VTreeComponentProps } from './FilterTree.types';
import { ITEM_SIZE } from './FilterTree.constants';

const NodeComponent: FC<VTreeComponentProps> = ({ data: { filter, nestingLevel }, style }) => {
  const isOpen = Boolean(filter.items && filter.items.length);

  return <Filter filter={filter} nestingLevel={nestingLevel} isOpen={isOpen} vtreeStyle={style} />;
};

class FilterTree extends React.Component<FilterTreeProps> {
  private createTreeWalker = memoize(createTreeWalker);

  public render(): React.ReactNode {
    const treeWalker = this.createTreeWalker(this.props.treeRoot);

    return (
      <AutoSizer>
        {({ height, width }) => (
          // @ts-ignore
          <Tree itemSize={ITEM_SIZE} treeWalker={treeWalker} width={width} height={height}>
            {/* @ts-ignore */}
            {NodeComponent}
          </Tree>
        )}
      </AutoSizer>
    );
  }
}

export default FilterTree;
