import React, { PureComponent, ReactNode } from 'react';
import cx from 'classnames';
import { ToggleProps } from './Toggle.types';
import css from './Toggle.module.css';

class Toggle extends PureComponent<ToggleProps> {
  public render(): ReactNode {
    const { onClick, isExpanded, className: outerClassName } = this.props;
    const className = cx(
      css.toggle,
      {
        [css.toggle_on]: isExpanded,
      },
      outerClassName,
    );

    return (
      <span role="presentation" className={className} onClick={onClick}>
        <span className={css.toggle__icon} />
      </span>
    );
  }
}

export default Toggle;
