import { ComponentType } from 'react';
import { connect } from 'react-redux';
import { withReduxContext, InjectedReduxContextProps } from 'modules/issues/redux';
import {
  ConnectedDispatchProps,
  ConnectedStateProps,
  InnerProps,
  OuterProps,
} from './TreeViewFilter.types';

export const withReduxState = (Component: ComponentType<InnerProps>) =>
  withReduxContext(
    connect<ConnectedStateProps, ConnectedDispatchProps, OuterProps & InjectedReduxContextProps>(
      (state, { redux, id, data }) => ({
        isSelected: String(id) === String((redux.selectors.getFastFilter(state) || {}).filterId),
        isLeaf: data.isLeaf,
      }),
      (dispatch, { redux, id, items, isExpanded, onSelect: onFilterSelect }) => ({
        onSelect: (id, isLeaf) => {
          onFilterSelect(id, isLeaf);
          return dispatch(
            redux.slices.filterSlice.actions.setWithRefresh({
              type: 'fast',
              data: { filterId: id },
            }),
          );
        },
        onExpand: () => {
          const collapse = () => {
            return dispatch(
              redux.slices.nodesSlice.asyncActions.getFilters({
                parentId: id,
                action: 'collapse',
                nodeId: `issueFilters.map.${id}`,
              }),
            );
          };

          const expand = () => {
            const offset = (items || []).length;
            return dispatch(
              redux.slices.nodesSlice.asyncActions.getFilters({
                parentId: id,
                offset,
                action: 'expand',
                nodeId: `issueFilters.map.${id}`,
              }),
            );
          };

          if (items && items.length && isExpanded) {
            collapse();
          } else if (!isExpanded) {
            expand();
          }
        },
      }),
    )(Component),
  ) as ComponentType<OuterProps>;
