import React, { useMemo } from 'react';
import { TreeView } from 'components/TreeView';
import { FilterItem } from 'components/TreeView/items/FilterItem';
import {
  getExpandedIds,
  treeViewFilterAdapter,
  disableItemSelectionPredicate,
} from './TreeViewFilter.utils';
import { TreeViewFilterProps } from './TreeViewFilter.types';
import { withReduxState } from './TreeViewFilter.connect';

export const TreeViewFilter: React.FC<TreeViewFilterProps> = ({ treeRoot }) => {
  const items = useMemo(() => treeViewFilterAdapter(treeRoot.items), [treeRoot]);
  const expandedItems = useMemo(() => getExpandedIds(items), [items]);

  return (
    <TreeView
      disableItemSelectionPredicate={disableItemSelectionPredicate}
      expanded={expandedItems}
      ItemComponent={withReduxState(FilterItem)}
      items={items}
    />
  );
};
