import { TreeNode } from 'components/TreeView/TreeView.types';
import { FilterItemProps } from 'components/TreeView/items/FilterItem';
import { NodeData } from '../utils/treeWalker';
import { TreeRoot } from '../utils/treeWalker';

export interface TreeViewFilterProps {
  treeRoot: TreeRoot;
}

export type ConnectedStateProps = Pick<FilterItemProps, 'isSelected' | 'isLeaf'>;

export type ConnectedDispatchProps = Pick<FilterItemProps, 'onSelect' | 'onExpand'>;

export type InnerProps = FilterItemProps;

export type OuterProps = FilterItemProps &
  TreeNode<
    NodeData & {
      label: string;
    }
  >;
