import { DataFilledNode } from '../utils/treeWalker';

export const getExpandedIds = (items) => {
  let result: string[] = [];

  items.forEach(({ items, id }) => {
    if (items?.length) {
      result.push(id);
      result = result.concat(getExpandedIds(items));
    }
  });

  return result;
};

export const getItemData = ({ id, name: label, items, ...other }: DataFilledNode) => {
  return { id, data: { label, ...other }, items: items?.map(getItemData) };
};

export const treeViewFilterAdapter = (items) => items.map(getItemData);

export const disableItemSelectionPredicate = (node) => node.data.disabled;
