import React, { FC } from 'react';
import { Filter as DesignFilter } from 'components/design/Filter';
import { InnerProps } from './Filter.types';
import { withReduxState } from '../../withReduxState';

const Filter: FC<InnerProps> = (props) => {
  return (
    <DesignFilter
      label={props.filter.name}
      value={props.filter.counter}
      isExpanded={props.isOpen}
      onExpand={props.onToggle}
      isDisabled={props.disabled}
      isPressed={props.active}
      onClick={props.onFilterClick}
      canExpand={!props.filter.isLeaf}
      depth={props.nestingLevel + 1}
      style={props.vtreeStyle}
    />
  );
};

const connected = withReduxState(Filter);
export { connected as Filter };
