import React, { FC } from 'react';
import AutoSizer from 'react-virtualized-auto-sizer';
import { FixedSizeTree as Tree } from 'react-vtree';
import { createTreeWalker } from './FilterTree.utils';
import { ITEM_SIZE } from './FilterTree.constants';
import { Filter } from '../Filter';
import { FilterTreeProps, VTreeComponentProps } from './FilterTree.types';

const NodeComponent: FC<VTreeComponentProps> = ({ data: { filter, nestingLevel }, style }) => {
  const isOpen = Boolean(filter.items && filter.items.length);

  return <Filter filter={filter} nestingLevel={nestingLevel} isOpen={isOpen} vtreeStyle={style} />;
};

export const FilterTree: FC<FilterTreeProps> = (props) => {
  const treeWalker = createTreeWalker(props.treeRoot);

  return (
    <AutoSizer>
      {({ height, width }) => (
        // @ts-ignore
        <Tree itemSize={ITEM_SIZE} treeWalker={treeWalker} width={width} height={height}>
          {/* @ts-ignore */}
          {NodeComponent}
        </Tree>
      )}
    </AutoSizer>
  );
};
