import { useEffect } from 'react';
import { XivaBackendEventType, XivaBackendEvents, CRMXiva } from 'modules/xiva';
import { config } from 'services/Config';

export const useXivaRefresh = (accessors: {
  xiva: CRMXiva;
  has: (id: number) => boolean;
  getById: (id: number) => { counter?: number | string };
  update: (updateRecord: Record<number, { counter: number }>) => void;
}) => {
  const { xiva, has, getById, update } = accessors;

  useEffect(() => {
    if (!config.value.features.useTicketStructuredFilters) {
      return;
    }

    const handle = (event: XivaBackendEvents[XivaBackendEventType.CountersChanged]) => {
      const xivaUpdate: Record<number, { counter: number }> = event.detail
        .filter((counterUpdate) => has(Number(counterUpdate.id)))
        .reduce((acc, counterUpdate) => {
          acc[counterUpdate.id] = { ...(getById(Number(counterUpdate.id)) || {}) };
          acc[counterUpdate.id].counter = Number(counterUpdate.value);
          return acc;
        }, {});

      update(xivaUpdate);
    };
    xiva.addEventListener(XivaBackendEventType.CountersChanged, handle);
    return () => {
      xiva.removeEventListener(XivaBackendEventType.CountersChanged, handle);
    };
  }, [xiva, getById, has, update]);
};
