import { TreeRoot, DataFilledNode, NodeId, NodeData } from './treeWalker';

export type TreeStructure = Record<
  NodeId,
  {
    eof: boolean;
    disabled: boolean;
    position: number;
    id: NodeId;
    counter: number;
    items?: NodeId[];
  }
>;

export type TreeData = Record<NodeId, NodeData>;

const merge = (
  treeStructure: TreeStructure,
  treeData: TreeData,
  nestingLevel: number = 0,
  itemsOfNodeId?: NodeId,
): DataFilledNode[] => {
  let list: NodeId[];
  if (itemsOfNodeId != null) {
    if (!treeStructure[itemsOfNodeId] || !treeStructure[itemsOfNodeId].items) {
      return [];
    }
    list = treeStructure[itemsOfNodeId].items as NodeId[];
  } else {
    list = Object.keys(treeStructure);
  }

  return list.map((nodeId: NodeId) => {
    const { color, name, counter, disabled } = treeData[nodeId];
    const { items, counter: structureCounter } = treeStructure[nodeId] || {};
    return {
      id: nodeId.toString(),
      color,
      name,
      counter,
      isLeaf: !structureCounter,
      disabled,
      nestingLevel,
      items: items ? merge(treeStructure, treeData, nestingLevel + 1, nodeId) : undefined,
    };
  });
};

export class TreeRootAdapter implements TreeRoot {
  public id: 0;

  public items: DataFilledNode[];

  public constructor(treeStructure: TreeStructure, treeData: TreeData) {
    this.id = 0;
    this.items = merge(treeStructure, treeData, 0, '0');
  }
}
