export type NodeId = string;

export interface LeafNode {
  id: NodeId;
}

export interface NonLeafNode {
  id: NodeId;
  items: DataFilledNode[];
}

export interface NodeData {
  id: NodeId;
  name: string;
  color: string;
  counter: string;
  nestingLevel: number;
  disabled: boolean;
  isLeaf: boolean;
  items?: DataFilledNode[];
}

export type DataFilledNode = NodeData & (LeafNode | NonLeafNode);

export interface TreeRoot {
  id: 0;
  items: DataFilledNode[];
}

export const createTreeWalker = (treeRoot: TreeRoot) => {
  return function* treeWalker(refresh: boolean) {
    const stack = [...treeRoot.items].reverse();

    while (stack.length !== 0) {
      const node = stack.pop();
      if (!node) {
        continue;
      }

      const { name, color, counter, nestingLevel, isLeaf, disabled } = node;
      let id = node.id.toString();
      const items = (node as NonLeafNode).items || [];

      yield refresh
        ? {
            defaultHeight: 27,
            isOpenByDefault: false,
            id,
            nestingLevel,
            filter: {
              name,
              color,
              counter,
              id,
              isLeaf,
              items,
              disabled,
            },
          }
        : id;

      if (items && items.length !== 0) {
        for (let i = items.length - 1; i >= 0; i--) {
          stack.push(items[i]);
        }
      }
    }
  };
};
