import { ComponentType } from 'react';
import { connect } from 'react-redux';
import { withReduxContext, InjectedReduxContextProps } from 'modules/issues/redux';
import {
  InnerProps,
  OuterProps,
  ConnectedDispatchProps,
  ConnectedStateProps,
} from './Filter/Filter.types';

export const withReduxState = (Component: ComponentType<InnerProps>) =>
  withReduxContext(
    connect<ConnectedStateProps, ConnectedDispatchProps, OuterProps & InjectedReduxContextProps>(
      (state, props) => ({
        active:
          String(props.filter.id) ===
          String((props.redux.selectors.getFastFilter(state) || {}).filterId),
      }),
      (dispatch, props) => ({
        onFilterClick: () => {
          return dispatch(
            props.redux.slices.filterSlice.actions.setWithRefresh({
              type: 'fast',
              data: { filterId: props.filter.id },
            }),
          );
        },
        onToggle: () => {
          const collapse = () => {
            const { filter, redux } = props;

            return dispatch(
              redux.slices.nodesSlice.asyncActions.getFilters({
                parentId: filter.id,
                action: 'collapse',
                nodeId: `issueFilters.map.${filter.id}`,
              }),
            );
          };

          const expand = () => {
            const { redux, filter } = props;

            const offset = ((filter || {}).items || []).length;
            return dispatch(
              redux.slices.nodesSlice.asyncActions.getFilters({
                parentId: filter.id,
                offset,
                action: 'expand',
                nodeId: `issueFilters.map.${filter.id}`,
              }),
            );
          };

          if (props.filter.items && props.filter.items.length && props.isOpen) {
            return collapse();
          }

          if (!props.isOpen) {
            expand();
          }
        },
      }),
    )(Component),
  ) as ComponentType<OuterProps>;
