import React from 'react';
import { Form, FieldRow, errorMessage } from 'components/FinalForm';
import { WorkflowFormProps, WithWorkflowItems } from './types';

const requiredFields = ['workflowId'];

const validate = values => {
  const errors = {};

  requiredFields.forEach(field => {
    if (!values[field]) {
      errors[field] = errorMessage.required;
    }
  });

  return errors;
};

const FormWorkflow: React.FC<WorkflowFormProps & WithWorkflowItems> = props => {
  const { onCancel, workflow, issueId, onSubmit, size, initialValues = {}, ...other } = props;

  return (
    <Form
      initialValues={initialValues}
      title="Изменить Воркфлоу"
      onSubmit={onSubmit}
      onCancel={onCancel}
      validate={validate}
      size={size}
      {...other}
    >
      <FieldRow
        name="workflowId"
        component="Select"
        label="Воркфлоу"
        size={size}
        inputProps={{
          options: workflow,
        }}
      />
    </Form>
  );
};

export default FormWorkflow;
