import * as React from 'react';
import { get } from 'api/common';
import Form from './Form';
import {
  WorkflowFormProps,
  WorkflowBackendResponse,
  WorkflowFormValues,
  WithWorkflowItems,
} from './types';

type State = {
  initialValues: WorkflowFormValues;
} & WithWorkflowItems;

class Init extends React.Component<WorkflowFormProps, State> {
  public state: State = {
    initialValues: {},
    workflow: [],
  };

  private promise: any;

  public componentDidMount() {
    this.promise = get({ url: '/issue/workflow/list', data: { issueId: this.props.issueId } }).then(
      (data: WorkflowBackendResponse) => {
        this.promise = null;
        this.setState({
          initialValues: data.values,
          workflow: (data.items || []).map(item => ({ value: item.id, content: item.name })),
        });

        return data;
      },
    );
  }

  public componentWillUnmount() {
    if (this.promise) {
      this.promise.cancel();
    }
  }

  public render() {
    return <Form {...this.state} {...this.props} />;
  }
}

export default Init;
