// TODO: задача на рефакторинг https://st.yandex-team.ru/CRM-10120
import React from 'react';
import {
  Form as BaseForm,
  FieldRow,
  Condition,
  errorMessage,
  withSave2LocalStorage,
  FormProps,
} from 'components/FinalForm';
import * as yup from 'yup';
import cachePromise from 'utils/cachePromise';
import { get } from 'api/common';
import { CasesFormValues } from './CreateForm.types';

const Form = withSave2LocalStorage<CasesFormValues>({
  localStorageKey: 'issueCreateForm',
})<FormProps<CasesFormValues>>(BaseForm);

const schema = yup.object().shape({
  name: yup.mixed().required(errorMessage.required),
  queue: yup.mixed().required(errorMessage.required),
  account: yup.mixed().required(errorMessage.required),
  category: yup.mixed().required(errorMessage.required),
  workflowId: yup.mixed().required(errorMessage.required),
  stateId: yup.mixed().required(errorMessage.required),
});

const subject = {
  map: {
    1: 'От Службы поддержки Яндекс.Маркета',
    2: 'Рекламная сеть Яндекса',
    3: 'ADFOX',
    4: 'От отдела клиентского сервиса',
    5: 'От отдела по работе с рекламными агентствами',
    6: 'ИНФО',
    7: 'От Службы поддержки Беру',
    8: 'Входящий звонок',
    9: 'Исходящий звонок',
    10: 'От отдела качества клиентского сервиса Яндекса',
    11: 'Экспертная поддержка Яндекс.Директ',
    12: 'Развитие бизнеса с Яндекс.Директом',
  },
  list: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12],
};

const nameProvider = (text = '') => {
  if (text) {
    const lowerText = text.toLowerCase();
    const result: { name: string; id: number }[] = [];

    subject.list.forEach((index) => {
      if (subject.map[index].toLowerCase().indexOf(lowerText) !== -1) {
        result.push({ name: subject.map[index], id: index });
      }
    });

    return result;
  }

  return subject.list.map((index) => ({ name: subject.map[index], id: index }));
};

const cacheQueue = cachePromise<{ name: string }[]>(() =>
  get({ url: '/view/support/queue/list?module=cases' }),
);

const queueProvider = (text: string) => {
  const formattedText = text.trim().toLowerCase();

  return cacheQueue().then((data) => ({
    items: data.filter((item) => item.name.toLowerCase().indexOf(formattedText) !== -1),
  }));
};

const exists = (value: unknown): boolean => Boolean(value);

const filterOwner = (key: string) => key !== 'owner';

export const CasesForm: React.FC<FormProps<CasesFormValues>> = (props) => {
  const {
    onCancel,
    onSubmit,
    size,
    initialValues = {} as CasesFormValues,
    onSubmitSuccess,
  } = props;

  return (
    <Form
      initialValues={initialValues}
      title="Создать новый тикет"
      onSubmit={onSubmit}
      onCancel={onCancel}
      onSubmitSuccess={onSubmitSuccess}
      validationSchema={schema}
      destroyOnUnregister
      size={size}
      filter={filterOwner}
    >
      <FieldRow
        name="name"
        component="Suggest"
        label="Тема"
        size={size}
        inputProps={{
          provider: nameProvider,
          showOnFocus: true,
          isCustomValue: true,
          isSingleValue: true,
        }}
      />
      <FieldRow
        name="queue"
        component="Suggest"
        label="Очередь"
        size={size}
        inputProps={{
          provider: queueProvider,
          showOnFocus: true,
          isSingleValue: true,
        }}
      />
      <FieldRow
        name="account"
        component="AccountInput"
        label="Клиент"
        size={size}
        inputProps={{
          hasNullAccount: true,
        }}
      />
      <Condition when="queue" is={exists}>
        {(queue) => (
          <>
            <FieldRow
              name="category"
              component="TreeInput"
              label="Категория"
              size={size}
              inputProps={{
                endpoint: `/view/support/category/list?queueId=${queue.id}&workplace=issueCreate`,
              }}
            />
            <FieldRow
              key={queue.id}
              name="workflowId"
              component="SelectWithLoad"
              label="Workflow"
              size={size}
              endpoint={`/issue/workflow/list?queueId=${queue.id}`}
              useCache={false}
              inputProps={{
                defaultValueIndex: 0,
              }}
            />
          </>
        )}
      </Condition>
      <Condition when="workflowId" is={exists}>
        {(workflowId) => (
          <FieldRow
            key={workflowId}
            name="stateId"
            component="SelectWithLoad"
            label="Статус"
            size={size}
            endpoint={`/issues/state?workflowId=${workflowId}`}
            useCache={false}
            inputProps={{
              defaultValueIndex: 0,
            }}
          />
        )}
      </Condition>
      <FieldRow
        name="owner"
        component="SuggestStaff"
        label="Исполнитель"
        size={size}
        inputProps={{ isSingleValue: true }}
        optional
      />
      <FieldRow
        name="count"
        component="TextInput"
        label="Количество"
        size={size}
        inputProps={{ type: 'number', width: 's', hasClear: false }}
        optional
      />
    </Form>
  );
};
