// TODO: задача на рефакторинг https://st.yandex-team.ru/CRM-10120
import React from 'react';
import { ModuleName } from 'modules/issues/types';
import { FormProps } from 'components/FinalForm';
import { IssueCreateFormProps, CasesFormValues } from './CreateForm.types';
import { CasesForm } from './CasesForm';
import { OpportunityForm } from './OpportunityForm';
import { OpportunityFormValues } from './OpportunityForm/OpportunityForm.types';

const CreateForm: React.FC<IssueCreateFormProps> = (props) => {
  const { moduleName = ModuleName.Ticket, ...rest } = props;

  if (moduleName === ModuleName.Ticket) {
    return <CasesForm {...(rest as FormProps<CasesFormValues>)} />;
  }

  return <OpportunityForm {...(rest as FormProps<OpportunityFormValues>)} />;
};

export default CreateForm;
