import { Account } from 'types';
import { FormProps } from 'components/FinalForm';
import { ModuleName } from 'modules/issues/types';
import { OpportunityFormValues } from './OpportunityForm/OpportunityForm.types';

interface Dictionary {
  id: number;
  name: string;
}

// Схема, которая используется на фронте
export interface CasesFormValues {
  name: { id?: number; name: string };
  queue: Dictionary;
  account: { id: number; name: string; login: string };
  category: Dictionary;
  workflowId: number;
  stateId: number;
  owner?: { id: number; name: string; login: string };
  count?: number;
}

export type CreateFormValues = CasesFormValues | OpportunityFormValues;

export interface IssueCreateFormProps<V extends {} = CreateFormValues> extends FormProps<V> {
  moduleName?: ModuleName;
  account?: Account;
}
