// TODO: задача на рефакторинг https://st.yandex-team.ru/CRM-10120
import React from 'react';
import {
  Form as BaseForm,
  FieldRow,
  errorMessage,
  withSave2LocalStorage,
} from 'components/FinalForm';
import * as yup from 'yup';
import { useSelector } from 'react-redux';
import { getCurrentUser } from 'entry/store/selectors';
import { OpportunityFormValues, OpportunityCreateFormProps } from './OpportunityForm.types';

const Form = withSave2LocalStorage<OpportunityFormValues>({
  localStorageKey: 'opportunityCreateForm',
})<OpportunityCreateFormProps>(BaseForm);

const schema = yup.object().shape({
  name: yup.mixed().required(errorMessage.required),
  account: yup.mixed().required(errorMessage.required),
  opportunitySource: yup.mixed().required(errorMessage.required),
});

export const OpportunityForm: React.FC<OpportunityCreateFormProps> = (props) => {
  const currentUser = useSelector(getCurrentUser);
  const {
    onCancel,
    onSubmit,
    size,
    initialValues = {
      owner: {
        name: currentUser.name,
        id: currentUser.id,
      },
    } as OpportunityFormValues,
    onSubmitSuccess,
    account,
  } = props;

  if (account) {
    initialValues.account = account;
  }

  return (
    <Form
      initialValues={initialValues}
      title="Создать сделку"
      onSubmit={onSubmit}
      onCancel={onCancel}
      successButtonText="Создать"
      cancelButtonText="Отмена"
      onSubmitSuccess={onSubmitSuccess}
      filter={(key) => key === 'owner'}
      validationSchema={schema}
      destroyOnUnregister
      size={size}
    >
      <FieldRow
        name="name"
        component="TextInput"
        label="Тема"
        hasLine={false}
        inputProps={{
          size,
        }}
      />
      <FieldRow
        name="account"
        component="AccountInput"
        label="Аккаунт"
        hasLine={false}
        size={size}
        inputProps={{
          hasNullAccount: true,
        }}
      />
      <FieldRow
        name="opportunitySource"
        component="SelectWithLoad"
        label="Источник"
        hasLine={false}
        size={size}
        endpoint="/dicts/issueOpportunitySource"
        useCache={false}
        inputProps={{
          defaultValueIndex: 3,
        }}
      />
      <FieldRow
        name="owner"
        component="SuggestStaff"
        label="Исполнитель"
        hasLine={false}
        size={size}
        inputProps={{ isSingleValue: true }}
        optional
      />
    </Form>
  );
};
