import { Account } from 'types';
import { FormProps } from 'components/FinalForm';
import { ModuleName } from 'modules/issues/types';

export interface OpportunityFormValues {
  name: string;
  account: {
    id: number;
    info: {
      name?: string;
      login?: string;
    };
  };
  opportunitySource: string;
  owner?: { id: number; name: string; login: string };
}

export interface OpportunityCreateFormProps<V extends {} = OpportunityFormValues>
  extends FormProps<V> {
  moduleName?: ModuleName;
  account?: Account;
}
