import { FormProps } from 'components/FinalForm';
import { IssueModalProps } from '../types';
import { IssueLinkRole } from '../../../types';

export enum IssueLinkRoleEN {
  Unknown = 'Unknown',
  Related = 'Related',
  Blocked = 'Blocked',
  BlockedBy = 'BlockedBy',
  Parent = 'Parent',
  Child = 'Child',
  Original = 'Original',
  Duplicate = 'Duplicate',
}

export enum IssueLinkRoleRU {
  Unknown = 'Удалить связь',
  Related = 'Связан с',
  Blocked = 'Блокирует',
  BlockedBy = 'Заблокирован',
  Parent = 'Родительский для',
  Child = 'Подзадача для',
  Original = 'Оригинал к',
  Duplicate = 'Дубликат к',
}

export const issueLinkRoleItems = [
  IssueLinkRole.Related,
  IssueLinkRole.Blocked,
  IssueLinkRole.BlockedBy,
  IssueLinkRole.Parent,
  IssueLinkRole.Child,
  IssueLinkRole.Original,
  IssueLinkRole.Duplicate,
].map(id => ({ value: String(id), content: IssueLinkRoleRU[IssueLinkRole[id]] }));

export interface LinkFormFormattedValues {
  linkRole: IssueLinkRole;
  targetId: number;
  issueId: number;
}

export interface LinkFormValues {
  linkRole: IssueLinkRole;
  targetId: string;
  issueId: number;
}

export type LinkFormProps = IssueModalProps & FormProps<LinkFormFormattedValues>;
