// TODO: задача на рефакторинг https://st.yandex-team.ru/CRM-10120
import React from 'react';
import { Form, FieldRow, errorMessage } from 'components/FinalForm';
import * as yup from 'yup';
import { RenameFormProps } from './RenameForm.types';

const schema = yup.object().shape({
  name: yup.mixed().required(errorMessage.required),
});

export const RenameForm: React.FC<RenameFormProps> = (props) => {
  const { onCancel, onSubmit, size, initialValues, onSubmitSuccess } = props;

  return (
    <Form
      initialValues={initialValues}
      title="Переименовать"
      onSubmit={(values, form) => onSubmit?.(values.name, form)}
      onCancel={onCancel}
      successButtonText="Сохранить"
      cancelButtonText="Отмена"
      onSubmitSuccess={onSubmitSuccess}
      validationSchema={schema}
      destroyOnUnregister
      size={size}
    >
      <FieldRow
        name="name"
        component="TextInput"
        label="Название"
        hasLine={false}
        inputProps={{
          size,
        }}
      />
    </Form>
  );
};
