import { modal as createSecondLineTicket, AppModuleString } from 'modules/requestForm2';
import { detachTicketModal } from 'modules/detachTicketForm';
import { DynamicallyModalFormService } from 'components/DynamicallyModalForm/DynamicallyModalForm.service';
import { CreateAccountFormModal } from 'modules/clientCreateForm';
import { NewTicketModalForm, ConnectTicketModalForm } from 'modules/startrek';
import { modal as changeWorkflow } from './ChangeWorkflow';
import { modal as link } from './Link';
import { modal as renameModal } from './RenameForm';
import { createTicketModalsTitle } from './constants';

export default {
  changeWorkflow,
  link,
  linkStartrek: ConnectTicketModalForm,
  createStartrek: NewTicketModalForm,
  createAccount: CreateAccountFormModal,
  detachTicket: detachTicketModal,
  createSecondLineTicket: {
    open: ({ issueId, actionName }) => {
      if (createSecondLineTicket.name === actionName) createSecondLineTicket.maximize();
      else {
        createSecondLineTicket.destroy();

        createSecondLineTicket.setName(actionName);
        createSecondLineTicket.open(
          {
            data: {
              data: { issueId },
              context: { module: AppModuleString.Ticket, action: actionName },
            },
            title: createTicketModalsTitle[actionName],
          },
          {
            canMinimize: true,
          },
        );
      }
    },
  },
  gridForm: {
    open: ({ activityForm, url }: { activityForm: DynamicallyModalFormService; url: string }) => {
      activityForm.setUrl(url).loadForm();
    },
  },
  rename: renameModal,
};
