import React, { PureComponent, ReactNode } from 'react';
import { ContactComponentProps } from 'components/Contact/Contacts.types';
import { ContactFull } from 'components/Contact';
import { ContactCreateModal } from 'modules/contactCreateForm';
import { jsonApiCall } from 'api/common';
import { getInitialValues } from 'components/Contact/utils';
import { ContactData } from 'types';
import { ContactProps } from './Contact.types';

class Contact extends PureComponent<ContactComponentProps & ContactProps> {
  private handleEdit = () => {
    const initialValues = getInitialValues(this.props.contact);

    const { accountId } = this.props;
    const { contactId } = this.props.contact;
    ContactCreateModal.open({
      form: this.props.formName,
      onSubmitSuccess: (contact) => {
        this.props.onEdit(contact);
      },
      initialValues,
      accountId,
      contactId,
    });
  };

  private getName = (contact?: ContactData): string | undefined => {
    let name: string | undefined;
    if (contact) {
      if (contact.firstName) {
        name = contact.firstName;
        if (contact.lastName) {
          name = `${name} ${contact.lastName}`;
        }
      }
    }

    return name;
  };

  private handleDelete = () => {
    const name = this.getName(this.props.contact);

    const confirmMessage = name
      ? `Вы уверены, что хотите удалить контакт "${name}"?`
      : `Вы уверены, что хотите удалить контакт?`;

    if (!window.confirm(confirmMessage)) {
      return;
    }

    jsonApiCall({
      url: '/actions/account/contact/delete',
      data: { contactId: this.props.contact.contactId },
    }).then(() => {
      this.props.onDelete(this.props.contact.contactId);
    });
  };

  public render(): ReactNode {
    return <ContactFull {...this.props} onEdit={this.handleEdit} onDelete={this.handleDelete} />;
  }
}

export default Contact;
