import React from 'react';
import { withReduxContext, InjectedReduxContextProps } from 'modules/issues/redux';
import { withIssueProps } from './IssuePropsContext';
import withFieldProps, { WrappedComponentProps } from './withFieldProps';
import { Field, SubmitData } from '../IssueField';

type Props = WrappedComponentProps & InjectedReduxContextProps;

class IssueField extends React.Component<Props> {
  private handleSubmit = (data: SubmitData) => {
    const { redux, issueId, dispatch } = this.props;

    return dispatch(redux.slices.issueSlice.asyncActions.fetchMutationIssue(issueId, data));
  };

  public render() {
    return <Field onSubmit={this.handleSubmit} {...this.props} />;
  }
}

export default withIssueProps(withFieldProps(withReduxContext<WrappedComponentProps>(IssueField)));
