import React from 'react';
import { connect } from 'react-redux';
import { withReduxContext } from 'modules/issues/redux';

export default withReduxContext(
  connect((state, props) => ({
    value: props.redux.selectors.storage.issues.getField(state, props.id, 'name') || '',
  }))(({ value, component: Component }) => {
    if (Component) {
      if (value) {
        return <Component>{value}</Component>;
      }

      return null;
    }

    return value;
  }),
);
