import React, { useContext, useCallback, memo } from 'react';
import {
  LayoutContainerWithXiva as FactorBlocks,
  FactorChangeCallback,
  FactorChangeEventType,
  FactorFile,
} from 'modules/upsale';
import { MailFileInputContext } from '../FileInputContext';
import css from './Issue.module.css';

interface Props {
  accountId: number;
  accountLogin: string;
  canEditUpsale: boolean;
  issueId: number;
}

export const IssuePanelFactors: React.FC<Props> = memo((props) => {
  const { accountId, accountLogin, canEditUpsale, issueId } = props;

  const mailFileInputRef = useContext(MailFileInputContext);

  const handleFactorChange = useCallback<FactorChangeCallback>(
    (event, factor) => {
      if (!mailFileInputRef.current) {
        return;
      }

      if (!factor.files) {
        return;
      }

      const mailFiles = mailFileInputRef.current.getCurrentFiles();

      const filesToLink: FactorFile[] = [];
      const filesToUnlink: FactorFile[] = [];

      let operationArray: FactorFile[] = [];
      if (event === FactorChangeEventType.Add) {
        operationArray = filesToLink;
      } else {
        operationArray = filesToUnlink;
      }

      for (let i = 0; i < factor.files.length; i += 1) {
        const file = factor.files[i];
        operationArray.push(file);
      }

      const nameMapper = mailFiles.reduce((ac, file) => {
        /* eslint-disable no-param-reassign */
        if (!ac[file.name]) {
          ac[file.name] = [];
        }
        ac[file.name].push(file.id);

        /* eslint-enable */

        return ac;
      }, {});

      const filteredFilesToUnlink = Object.keys(
        filesToUnlink.reduce((ac, file) => {
          /* eslint-disable no-param-reassign */
          ac[file.name] = true;
          /* eslint-enable */
          return ac;
        }, {}),
      )
        .map((name) => nameMapper[name])
        .filter((arr) => arr)
        .reduce((ac, arr) => ac.concat(arr), []);

      if (!filesToLink.length && !filteredFilesToUnlink.length) {
        return;
      }

      mailFileInputRef.current.updateFiles(
        filesToLink.map((file) => file.id),
        filteredFilesToUnlink,
      );
    },
    [mailFileInputRef],
  );

  return (
    <div data-testid="issue-factors" className={css.b__factors}>
      <FactorBlocks
        accountId={accountId}
        accountLogin={accountLogin}
        isSupportCopyToClipboard
        canCancelUpsale={canEditUpsale}
        mode="issue"
        issueId={issueId}
        clickDisabled={!canEditUpsale}
        isSupportSaveDraft={canEditUpsale}
        isSupportSaveFactors={canEditUpsale}
        onFactorChange={handleFactorChange}
      />
    </div>
  );
});
