import React from 'react';
import createLink from 'modules/issues/utils/createLink';
import { withIssueProps } from './IssuePropsContext';
import withFieldProps from './withFieldProps';
import css from './IssueParent.module.css';

interface Props {
  value?: {
    id: number;
    name: string;
    typeId: number;
  };
}

const IssueParent: React.FC<Props> = ({ value }) => {
  if (!value) {
    return null;
  }

  const { id, name, typeId = 3 } = value;

  const issueUrl = createLink({
    typeId,
    id,
  });

  return (
    <span className={css.b}>
      <a className={css.b__link} href={issueUrl} target="_blank" rel="noopener noreferrer">
        {id} {name}
      </a>
    </span>
  );
};

export default withIssueProps(withFieldProps(IssueParent));
