import React from 'react';
import { Dispatch } from 'redux';
import createContextHOC from 'utils/createContextHOC';
import { Redux } from 'modules/issues/redux/types';
import { IssueObject } from '../../types';

export interface ContextProps {
  issue: IssueObject;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  dispatch: Dispatch<any>;
  redirect?: () => void;
  maxAccess?: number;
  more?: React.ReactElement;
  redux: Redux;
}

export interface InjectedContextProps {
  issue: ContextProps;
}

export const IssuePropsContext = React.createContext<ContextProps>(Object());

export const withIssueProps = createContextHOC<ContextProps, InjectedContextProps>({
  Context: IssuePropsContext,
  propName: 'issue',
});

export default IssuePropsContext;
