import React from 'react';
import { withReduxContext, InjectedReduxContextProps } from 'modules/issues/redux';
import { withIssueProps, InjectedContextProps } from './IssuePropsContext';
import { StartrekItem, StartrekItemProps } from '../Startrek';

type Props = InjectedReduxContextProps & InjectedContextProps & StartrekItemProps;

class IssueStartrekItem extends React.Component<Props> {
  private handleUnlink = (stKey: string) => {
    const { redux, issue } = this.props;
    const { dispatch } = issue;

    const issueId = issue.issue.id;

    return dispatch(
      redux.slices.issueSlice.asyncActions.fetchMutationIssue(issueId, {
        name: 'unlinkStartrek',
        value: { issueId, key: stKey },
      }),
    );
  };

  public render() {
    const { redux, issue, ...other } = this.props;

    return <StartrekItem unlink={this.handleUnlink} {...other} />;
  }
}

export default withIssueProps(withReduxContext(IssueStartrekItem));
