import { useEffect, useContext } from 'react';
import { useDispatch } from 'react-redux';
import { XivaContext, XivaBackendEventType } from 'modules/xiva';
import { ETypeString } from 'types/entities';
import { ReduxContext } from '../../redux';

export const useXivaRefresh = (issueId: number) => {
  const xiva = useContext(XivaContext);
  const redux = useContext(ReduxContext);
  const dispatch = useDispatch();

  useEffect(() => {
    const handle = () => {
      dispatch(redux.slices.moduleSlice.asyncActions.refresh({}));
    };
    const topic = `${ETypeString.Issue}@${issueId}`;

    xiva.addTopic(topic);
    xiva.addEventListener(XivaBackendEventType.IssueChange, handle);
    return () => {
      xiva.removeTopic(topic);
      xiva.removeEventListener(XivaBackendEventType.IssueChange, handle);
    };
  }, [xiva, issueId, dispatch, redux.slices.moduleSlice.asyncActions]);
};
