import React from 'react';
import { Dispatch } from 'redux';
import { WithOId } from 'types';
import get from 'lodash/get';
import Access from 'utils/Access';
import { FieldProps } from 'types/Attributes';
import { InjectedContextProps } from './IssuePropsContext';
import { IssueFieldSchemeProps } from '../../types';

export interface WrappedComponentProps extends IssueFieldSchemeProps, WithOId {
  // eslint-disable-next-line
  value: any;
  issueId: number;
  redirect?: () => void;
  // eslint-disable-next-line
  dispatch: Dispatch<any>;
}

export default (WrappedComponent: React.ComponentType<WrappedComponentProps>) => {
  const WithFieldProps: React.FC<IssueFieldSchemeProps & InjectedContextProps> = (props) => {
    const { issue, propsSlug, ...otherProps } = props;

    const { name } = props;

    const { access: backendAccess, ...otherBackendProps } = get(
      issue,
      ['issue', 'props', propsSlug || name],
      {},
    ) as FieldProps;

    const issueId = get(issue, ['issue', 'id']) as number;

    let resultAccess = backendAccess || 0;
    const resultMaxAccess = issue.maxAccess || props.maxAccess;

    if (resultMaxAccess && Number.isInteger(resultMaxAccess)) {
      resultAccess = Math.min(resultAccess, resultMaxAccess);
    }

    const resultProps = {
      value: get(issue, ['issue', 'data', name]),
      issueId,
      oId: {
        eId: issueId,
        eType: 'Issue',
      },
      access: resultAccess,
      redirect: issue.redirect,
      issue: undefined,
      dispatch: issue.dispatch,
      ...otherProps,
      fieldProps: {
        ...otherBackendProps,
        ...otherProps.fieldProps,
      },
    };

    if (!Access.isRead(resultProps.access)) {
      return null;
    }

    return <WrappedComponent {...resultProps} />;
  };

  return WithFieldProps;
};
