import React, { FC, useContext } from 'react';
import { ETypeString } from 'types/entities';
import webphoneStateContext from 'modules/webphone/components/WebphoneStateContext/webphoneStateContext';
import { showPinModal } from 'modules/pinForm';
import ClientSelectInputWithModal from 'modules/clientSelectInputWithModal';
import Access from 'utils/Access';
import { preview } from 'components/PreviewValue';
import { AccountBlockProps } from './AccountBlock.types';
import { IssueAttributeContext } from '../IssueAttributeContext';
import { IssueIdContext } from '../../Issue/IssueIdContext';
import css from './AccountBlock.module.css';

const AccountBlock: FC<AccountBlockProps> = (props) => {
  const issueId = useContext(IssueIdContext);
  const { call } = useContext(webphoneStateContext);
  const { onChange, fieldProps } = useContext(IssueAttributeContext);

  const handlePinButtonClick = () => {
    const callId: number | undefined = (call || {}).crmCallId;

    showPinModal({
      pinSource: callId ? { eid: callId, etype: ETypeString.YcCall } : undefined,
      pinTarget: { eid: issueId, etype: ETypeString.Issue },
    });
  };

  const showPinButton = Boolean(call && call.crmCallId);
  return (
    <>
      <preview.PreviewAccountBlock
        showPhoneStatus
        {...props}
        placeholder={showPinButton ? <></> : null}
      />
      <ClientSelectInputWithModal
        className={css.AccountBlock__actions}
        onChange={onChange}
        onPinButtonClick={showPinButton ? handlePinButtonClick : undefined}
        hasInlineSearch={false}
        hasModalSearch={false}
        isNullAccount={Access.isEdit(fieldProps.accessNullAccount)}
        isCreateAccount={Access.isEdit(fieldProps.accessCreateAccount)}
        canCreateLead={Access.isEdit(fieldProps.accessCreateLead)}
        multiline
        size="xs"
      />
    </>
  );
};

export { AccountBlock };
