import React, { FC } from 'react';
import { Widget as ActualWidget } from 'modules/categorization2';
import { WidgetProps } from './Widget.types';
import css from './Widget.module.css';
import { useCategorizationInitialization } from './useCategorizationInitialization';

export const Widget: FC<WidgetProps> = (props) => {
  const data = useCategorizationInitialization()(props);

  return (
    <>
      {props.value && <div className={css.valueName}>{props.value.name}</div>}
      <ActualWidget
        mini
        targetMeta={data.targetMeta}
        Preview={data.previewComponent}
        onLoad={data.load}
        onSearch={data.search}
        onTipLoad={data.loadTip}
        onAlertsLoad={data.loadAlerts}
        onTipComment={data.commentSubmit}
        onSave={data.save}
        changeStrategy={data.changeStrategy}
      />
    </>
  );
};
