import React, { FC, useMemo } from 'react';
import Attribute from 'components/Attribute';
import { IssueAttributeContext } from '../IssueAttributeContext';
import { IssueAttributeWithContextProps } from './IssueAttributeWithContext.types';

export const IssueAttributeWithContext: FC<IssueAttributeWithContextProps> = (props) => {
  const { onChange, onClear, onAdd, onRemove, fieldProps } = props;

  const issueContextValue = useMemo(() => ({ onChange, onClear, onAdd, onRemove, fieldProps }), [
    onAdd,
    onChange,
    onClear,
    onRemove,
    fieldProps,
  ]);

  return (
    <IssueAttributeContext.Provider value={issueContextValue}>
      <Attribute {...props} />
    </IssueAttributeContext.Provider>
  );
};
