import { attributesAdapter, createAttributeMeta } from 'components/Attribute/adapters';
import { Theme, EditMode } from 'components/Attribute/types';
import { preview } from 'components/PreviewValue';
import AccountBlock from './AccountBlock';
import { Widget } from './CategorizationAttribute';

const issueAttributesAdapter = attributesAdapter.copy();
issueAttributesAdapter.add(
  'AccountInput',
  createAttributeMeta({
    theme: Theme.Column,
    previewComponent: AccountBlock,
    editFieldPropsAdapter: () => ({
      hasNullAccount: true,
    }),
  }),
);

issueAttributesAdapter.add(
  'Categorization',
  createAttributeMeta({
    editFieldPropsAdapter: ({ provider, ...restProps }) => ({
      ...restProps,
      endpoint: provider,
    }),
    editMode: EditMode.Custom,
    editComponent: Widget,
    previewComponent: preview.PreviewDictionary,
  }),
);

export { issueAttributesAdapter };
