import * as React from 'react';

const sp = e => {
  e.stopPropagation();
};

interface Props {
  children: React.ReactNode;
  className?: string;
}

const style = {
  display: 'contents',
};

const BlockPropagation = ({ children, className }: Props) => (
  <span
    role="presentation"
    className={className}
    onClick={sp}
    onKeyPress={sp}
    onKeyDown={sp}
    style={style}
  >
    {children}
  </span>
);

BlockPropagation.stopPropagationHandle = sp;

export default BlockPropagation;
