import React from 'react';
import IssueFieldInline from './IssueFieldInline';
import IssueFieldModal from './IssueFieldModal';
import IssueFieldCustom from './IssueFieldCustom';
import IssueFieldPopup from './IssueFieldPopup';
import { FieldEditType, EditType, SubmitValueMapper, SubmitOptions, FieldProps } from './types';

const MapEditTypeToComponent = {
  [EditType.Inline]: IssueFieldInline,
  [EditType.Modal]: IssueFieldModal,
  [EditType.Popup]: IssueFieldPopup,
  [EditType.Custom]: IssueFieldCustom,
};

export default class Field extends React.Component<FieldProps> {
  state = {
    isLoading: false,
  };
  public handleClear = () => {
    return this.handleSubmit(null);
  };

  public handleSubmit = (value: unknown, options: SubmitOptions = {}) => {
    const { backendUpdateKey, name, component, redirect, onSubmit } = this.props;

    const backendName = backendUpdateKey || name;

    const submitName = options.name || backendName;
    this.setState({ isLoading: true });
    return onSubmit({
      name: submitName,
      value: value == null ? null : SubmitValueMapper.get(component)(value),
      options,
    })
      .then((data) => {
        if (options.redirect && redirect) {
          // redirect to main route
          // for delete as example
          redirect();
        }
        return data;
      })
      .finally(() => {
        this.setState({ isLoading: false });
      });
  };

  public render() {
    const { component } = this.props;

    const editType = FieldEditType[component] as EditType;
    if (!editType) {
      return null;
    }

    const Component = MapEditTypeToComponent[editType];

    return (
      <Component
        {...this.props}
        isLoading={this.state.isLoading}
        onSubmit={this.handleSubmit}
        onClear={this.handleClear}
      />
    );
  }
}
