import React from 'react';
import css from './IssueField.module.css';
import IssueFieldBase from './IssueFieldBase';
import { InlineForm } from './IssueFieldEditForm';
import BlockPropagation from './BlockPropagation';

export default class IssueFieldInline extends IssueFieldBase {
  protected renderField(isEditMode: boolean) {
    const { value, onSubmit, name, component, issueId, fieldProps, context } = this.props;

    return (
      isEditMode && (
        <BlockPropagation>
          <InlineForm
            component={component}
            fieldProps={fieldProps}
            onCancel={this.toggle}
            value={value}
            issueId={issueId}
            name={name}
            context={context}
            onSubmit={onSubmit}
            editRef={this.editRef}
          />
        </BlockPropagation>
      )
    );
  }

  protected renderPreviewRow(isEditMode: boolean) {
    return (
      !isEditMode && (
        <span className={css.b}>
          {this.renderPreview()}
          {this.renderEditButton()}
          {this.renderRemoveButton()}
        </span>
      )
    );
  }
}
