import React from 'react';
import { ModalForm as AccountModal } from 'modules/clientSelectForm';
import css from './IssueField.module.css';
import IssueFieldBase from './IssueFieldBase';
import BlockPropagation from './BlockPropagation';

const Modals = {
  AccountModal,
};

export default class IssueFieldModal extends IssueFieldBase {
  public renderField(isEditMode: boolean) {
    const { value, onSubmit, name, component, context } = this.props;

    const Modal = Modals[component];

    return (
      isEditMode && (
        <BlockPropagation>
          <Modal
            value={value}
            name={name}
            context={context}
            onSubmit={onSubmit}
            modalProps={{ onClose: this.toggle, autoOpen: true }}
          />
        </BlockPropagation>
      )
    );
  }

  public renderPreviewRow() {
    return (
      <span className={css.b}>
        {this.renderPreview()}
        {this.renderEditButton()}
        {this.renderRemoveButton()}
      </span>
    );
  }
}
