import React from 'react';
import css from './IssueField.module.css';
import IssueFieldBase from './IssueFieldBase';
import BlockPropagation from './BlockPropagation';
import { PopupForm } from './IssueFieldEditForm';

export default class IssueFieldPopup extends IssueFieldBase {
  public renderField(isEditMode: boolean) {
    const { value, onSubmit, onClear, name, component, issueId, fieldProps, context } = this.props;

    return (
      isEditMode && (
        <BlockPropagation>
          <PopupForm
            component={component}
            fieldProps={fieldProps}
            onCancel={this.toggle}
            value={value}
            issueId={issueId}
            name={name}
            context={context}
            onSubmit={onSubmit}
            onClear={onClear}
            editRef={this.editRef}
          />
        </BlockPropagation>
      )
    );
  }

  public renderPreviewRow() {
    return (
      <span className={css.b}>
        {this.renderPreview()}
        {this.renderEditButton()}
        {this.renderRemoveButton()}
      </span>
    );
  }
}
