import React from 'react';
import { preview } from 'components/PreviewValue';

interface Props {
  component?: string;
  className?: string;
  value: any;
  previewProps?: any;
}

const Preview: React.FC<Props> = props => {
  const { className, value, component, previewProps } = props;

  const PreviewComponent = preview[component] || preview.PreviewValue;

  return <PreviewComponent className={className} value={value} {...previewProps} />;
};

Preview.defaultProps = {
  previewProps: null,
};

export default Preview;
